function [yleft,yright]=stereoverb(x,d,cg,cg1,cd,ag,ad,k)

%This is a stereo reverberator based on Moorer's design which consists of 6 parallel feedback comb filters 
%(each with a low pass filter in the feedback loop) in series with an all pass filter. A delay of d samples 
%is applied to the right channel so that the channels are decorrelated. 
%
%The structure is:  [yleft,yright] = stereoverb(x,d,cg,cg1,cd,ag,ad,k)
%
%where x = the input signal
%      d = the amount of delay applied to the right channel (to uncorrelate the two channels)
%      cg = a vector of length 6 which contains g2/(1-g1) (this should be less than 1 for stability),
%           where g2 is the feedback gain of each of the comb filters and g1 is from the following parameter 
%      cg1 = a vector of length 6 which contains the gain of the low pass filters in the feedback loop of
%            each of the comb filters (should be less than 1 for stability)
%      cd = a vector of length 6 which contains the delay of each of the comb filters 
%      ag = the gain of the allpass filter (this should be less than 1 for stability)
%      ad = the delay of the allpass filter 
%      k = the gain factor of the direct signal
%      yleft = the output signal (which appears to come from the left (ITD) )
%      yright = the output signal (which appears to come from the right (ITD) )
%
%
% Gautham J. Mysore - gauthamjm@yahoo.com
%


%apply Moorer reverberation to the signal
y1 = moorer(x,cg,cg1,cd,ag,ad,k);

%delay the signal by d samples
y2 = delay(y1,d);

%zero pad the original signal by d samples
y1 = [y1 ; zeros(d,1)]; 

%combine the delayed and the zero padded signals to get stereo reverb
yleft = [y1 y2];
yright = [y2 y1];